
/* ***************************************************
   ROM Example
   First, calculate the table
   ***************************************************
   */

import  java.io.*;


class BuildTable {
    // Build a table of 256 2-byte unsigned hex entries corresponding
    // to the sin values for between 0 and PI
    public static void main( String args[] )
    {
        final int nPoints = 256;
        for (int i = 0; i<nPoints; i++) {
            double radians = i * Math.PI / nPoints;
            int tableValue = (int)(Math.sin(radians) * 65535);
            System.out.print("\\u"+Integer.toHexString(tableValue));
        }
        System.out.println( "" );
    }
}

class CalculateSin {
    static final String Values =
        // N.b. leading zeros added by hand.
        "\u0000\u0324\u0648\u096c\u0c8f\u0fb2\u12d5\u15f6\u1917\u1c37\u1f56\u2273\u258f\u28aa\u2bc3\u2edb\u31f1\u3505\u3816\u3b26\u3e33\u413e\u4447\u474c\u4a4f\u4d4f\u504d\u5347\u563e\u5931\u5c21\u5f0e\u61f7\u64dc\u67bd\u6a9a\u6d73\u7048\u7319\u75e5\u78ac\u7b6f\u7e2e\u80e7\u839b\u864a\u88f5\u8b99\u8e39\u90d3\u9367\u95f6\u987f\u9b02\u9d7f\u9ff6\ua266\ua4d1\ua735\ua993\uabea\uae3b\ub085\ub2c8\ub504\ub739\ub967\ubb8e\ubdae\ubfc6\uc1d7\uc3e1\uc5e3\uc7dd\uc9d0\ucbbb\ucd9e\ucf79\ud14c\ud317\ud4da\ud695\ud847\ud9f1\udb93\udd2c\udebd\ue045\ue1c4\ue33b\ue4a9\ue60e\ue76a\ue8be\uea08\ueb4a\uec82\uedb1\ueed7\ueff4\uf108\uf212\uf313\uf40a\uf4f9\uf5dd\uf6b9\uf78a\uf852\uf911\uf9c6\ufa72\ufb13\ufbab\ufc3a\ufcbe\ufd39\ufdaa\ufe12\ufe6f\ufec3\uff0d\uff4d\uff83\uffb0\uffd2\uffeb\ufffa\uffff\ufffa\uffeb\uffd2\uffb0\uff83\uff4d\uff0d\ufec3\ufe6f\ufe12\ufdaa\ufd39\ufcbe\ufc3a\ufbab\ufb13\ufa72\uf9c6\uf911\uf852\uf78a\uf6b9\uf5dd\uf4f9\uf40a\uf313\uf212\uf108\ueff4\ueed7\uedb1\uec82\ueb4a\uea08\ue8be\ue76a\ue60e\ue4a9\ue33b\ue1c4\ue045\udebd\udd2c\udb93\ud9f1\ud847\ud695\ud4da\ud317\ud14c\ucf79\ucd9e\ucbbb\uc9d0\uc7dd\uc5e3\uc3e1\uc1d7\ubfc6\ubdae\ubb8e\ub967\ub739\ub504\ub2c8\ub085\uae3b\uabea\ua993\ua735\ua4d1\ua266\u9ff6\u9d7f\u9b02\u987f\u95f6\u9367\u90d3\u8e39\u8b99\u88f5\u864a\u839b\u80e7\u7e2e\u7b6f\u78ac\u75e5\u7319\u7048\u6d73\u6a9a\u67bd\u64dc\u61f7\u5f0e\u5c21\u5931\u563e\u5347\u504d\u4d4f\u4a4f\u474c\u4447\u413e\u3e33\u3b26\u3816\u3505\u31f1\u2edb\u2bc3\u28aa\u258f\u2273\u1f56\u1c37\u1917\u15f6\u12d5\u0fb2\u0c8f\u096c\u0648\u0324\u0000\u0000";

    static final int nPoints = 256;

    public static float sin( float radians ) {
        // radians between 0 and pi
        float point = (radians / (float)Math.PI) * nPoints;
        int lowVal = (int) point;
        int hiVal = lowVal + 1;
        float lowValSin = (float)Values.charAt(lowVal) / 65535;
        float hiValSin = (float)Values.charAt(hiVal) / 65535;
        float result = ((float)hiVal - point) * lowValSin 
            + (point - (float)lowVal) * hiValSin; 
        return result;
    }

    public static void assert (boolean  assertion, String excuse) {
        if  (!assertion) { throw new RuntimeException(excuse);}
    }

    public static void progress (String msg) {System.out.print(msg);}

    public static boolean isNearly( float a, float b ) {
        return Math.abs( b - a ) < 0.00005;
    }

    public static void main( String args[] ) {
        for (float f = 0; f < Math.PI; f += 0.05) {
            progress( "." );
            assert( isNearly( sin( f ), (float)Math.sin( f ) ), 
                    "Sin failed for " + f + ": " + sin( f ) + 
                    " != " + Math.sin(f) );
        }
        System.out.println( " " );
        int repetitions = 250000;
        long l1 = System.currentTimeMillis();
        for (int i = 0; i<repetitions; i++) {
            double x = Math.sin( 1.0 ); }
        long l2 = System.currentTimeMillis();
        for (int i = 0; i<repetitions; i++) {
            float x = sin( 1 ); }
        long l3 = System.currentTimeMillis();            
        System.out.println( "Native took " + (l2 - l1) + " Fast took " + (l3-l2) );
    }
}




