// **************************************************************************
// Hooks.cpp
//
// C code to implement hooks.
// **************************************************************************

#include <iostream.h>
#include <assert.h>

typedef void* sysobj;

const int SIO_HOOK_TABLE_SIZE = 100;
const int SIO_MEMALLOC = 0;

typedef sysobj (*sio_hook_function) (sysobj) ;

extern sysobj sio_memalloc( sysobj );

sio_hook_function sio_hook_table[SIO_HOOK_TABLE_SIZE];

sysobj sio_memalloc( sysobj ) {
    return (sysobj)0;
}
void *memalloc(size_t bytesToAllocate) {
    return (void*)sio_hook_table[SIO_MEMALLOC]((sysobj)bytesToAllocate);
}

static sio_hook_function original_memalloc  = 0;
static size_t mem_counter = 0;


sysobj mem_counter_memalloc(sysobj size) {
    mem_counter += (size_t)size;
    return original_memalloc( size );
}

int main() {
    sio_hook_table[SIO_MEMALLOC] = sio_memalloc;

    (void)memalloc( 10 );
    assert( mem_counter == 0 );

    original_memalloc = sio_hook_table[SIO_MEMALLOC];
    sio_hook_table[SIO_MEMALLOC] = mem_counter_memalloc;

    (void)memalloc( 10 );
    assert( mem_counter == 10 );
    cout << "Completed\n";
    cin.get();
    return 0;
}
