

public class Resource {
    private Object m_waiter = new Object();
    // Provides synchronization of the resource.

    public void release() {
        // Function to be called by thread that's releasing the resource
        synchronized (m_waiter){
            m_waiter.notify(); 
        }
    }
    
    public void get() {
        // Block until the resource is available
        synchronized (m_waiter) {
            boolean doContinue = true;
            while (true) {
                try { 
                    m_waiter.wait(0); 
                    break;
                }    
                catch (InterruptedException e) { ; }  // Thread end or new resource to validate
            }
        }
    }


    public class WorkThread extends Thread
    {

        public WorkThread()
        {
        }


        public void run()
        // Do the processing.
        {
            m_threadGroup = new ThreadGroup( getThreadGroup(), "URL Validation Group");
                
            try {
                while (stillMoreToDo())
                    {
                                // We really want a "wait for thread death" function on
                                // ThreadGroup - but it doesn't seem to exist.
                                // Instead each child thread interrupts this one before dying using 
                                // the monitor in m_waiter.
                                // (We don't use our own monitor because that synchronizes access to the collection)

                                // The following should be in the synchronized bit, otherwise a terminating thread may signal
                                // to us before we start waiting for a signal.  But that doesn't work for some reason.
                        startAsManyThreadsAsPossible();

                        synchronized (m_waiter)
                            {
                                // Wait for a thread to terminate
                                try { m_waiter.wait( 5000 ); }    // Not zero; the last thread might already have terminated.
                                catch (InterruptedException e) { ; }  // Thread end or new resource to validate
                            }
                    }
            }
            catch (ThreadDeath e)
                {
                    // Terminate all owned threads so we don't get them trying to print.
                    m_threadGroup.stop();
                }
            catch (Exception e)
                {
                    print( "Caught exception: " + e.toString() ); 
                }
        }

        private synchronized boolean stillMoreToDo()
        // Answers true if we've not completed the analysis:
        {
            return nextResourceToValidate() != null 
                || m_threadGroup.activeCount() != 0;
        }

        private void startAsManyThreadsAsPossible()
        // Starts up to MAX_OUTSTANDING_REQUESTS validation threads going.  
        {
            ResourceToValidate rv;
            while ((rv = nextResourceToValidate()) != null
                   && m_threadGroup.activeCount() < MAX_OUTSTANDING_REQUESTS)
                {
                    print( "Starting thread to validate: " + rv.getURL().toString() );
                    rv.setStateToRunning();
                    Thread t = new Thread( m_threadGroup, rv, rv.getURL().toString() );
                    t.setPriority( getPriority() + 1 );
                    t.start();
                }
        }

        private synchronized ResourceToValidate nextResourceToValidate()
        // Answers a new resource which hasn't yet been validated, or null if none.
        {
            for (Enumeration e=m_resourcesFound.elements(); 
                 e.hasMoreElements(); )
                {
                    ResourceToValidate rv=(ResourceToValidate)e.nextElement();
                    if (rv.notYetChecked())
                        return rv;
                }
            return null;
        }

        public void print( String aString )
        // Prints a status message.
        {
            m_printer.print( aString );
        }

        public void printBadLinks()
        // Print the report of all the bad links found.
        {
            int totalErrors = 0;
            m_printer.print( "\nERRORS FOUND:\n" );
            // Special case: can't load initial resource:
            if (m_resourcesFound.size() == 1)
                {
                    ResourceToValidate rv = (ResourceToValidate)m_resourcesFound.elements().nextElement();
                    if (!rv.validAsInitialURL())
                        {
                            print( "Cannot load initial page.   " + rv.problemDescription() );
                            totalErrors++;
                        }
                }

            for (Enumeration e=m_resourcesFound.elements();
                 e.hasMoreElements(); )
                {
                    ResourceToValidate rv = (ResourceToValidate)e.nextElement();
                    Vector v = rv.getMalformedLinks();
                    if (v == null || v.size() == 0)
                        continue;
                    m_printer.print( "In " + rv.getURL().toString() );
                    for (Enumeration ev=v.elements(); ev.hasMoreElements(); )
                        {
                            totalErrors++;
                            Link l = (Link)ev.nextElement();
                            m_printer.print( "  " + l.description() );
                        }
                }
            if (totalErrors == 0)
                m_printer.print( "None" );
        }

        public synchronized ResourceToValidate addResourceToValidate( URL aURL )
        // Called by a validation thread when it's found a (possibly) new resource to 
        // validate:
        {
            String urlString = aURL.toString();
            if (m_resourcesFound.containsKey( urlString ))
                return (ResourceToValidate)m_resourcesFound.get( urlString );
            ResourceToValidate res = new ResourceToValidate( this, aURL );
            m_resourcesFound.put( urlString, res );
            acceptNotify();
            return res;
        }

    }
