 
/* ***************************************************
   Fixed Data Structure Example
   Message Store 
   ***************************************************
   */

#include <iostream.h>
#include <string.h>
#include <stdio.h>
#include <stddef.h>

static void test(char* input[], char* output[], int nMessagesInStore, int maxMsgLength);


int min( int i, int j ) { return i > j ? j: i; }

static void Assert (bool  assertion, char* excuse) {
    if  (!assertion) { 
        cerr << "Assertion failed: " << excuse << endl;  
    }
}

class MessageStore {
private:
    char* messageBuffer;
    int oldestMessageNumber;
    int nMessagesInStore;
    int maxMessageLength;
    int maxMessagesInStore;
    
public:
    MessageStore(int capacity, int maxMsgLength) 
        : maxMessagesInStore( capacity ),
          maxMessageLength( maxMsgLength ),
          oldestMessageNumber( 0 ),
          nMessagesInStore( 0 ) {
            messageBuffer = new char[Capacity() * MessageStructureSize()];
            Assert( NMessagesInStore() == 0, "buffer calcuations wrong" );
        }
    
    void AcceptMessage(const char* newMessageText) {
        int nextMessage = (oldestMessageNumber + NMessagesInStore()) % Capacity();
        int newMessageLength = strlen( newMessageText );
        int nBytesToCopy = min(newMessageLength,maxMessageLength)+1;
        strncpy(MessageAt(nextMessage), newMessageText, nBytesToCopy);
        MessageAt(nextMessage)[maxMessageLength] = '\0';
        if (NMessagesInStore() == Capacity()) { 
            oldestMessageNumber = (oldestMessageNumber + 1) % Capacity();
        } else {
            nMessagesInStore++;
        }
    }

    // GetMessage: Answers a message.  0 returns the oldest.
    const char* GetMessage(int i) {
        int messageIndex = (oldestMessageNumber + i) % Capacity();
        return MessageAt(messageIndex); 
    }

    int NMessagesInStore()      { return nMessagesInStore; }
    int Capacity()              { return maxMessagesInStore; } 
    int MessageStructureSize()  { return maxMessageLength+1; }

private:
    char * MessageAt( int i ) { 
        return messageBuffer + i*MessageStructureSize(); 
    }
};

int main( int argc, char** argv ) {
    char* a = "one string";
    char* b  = "twostring";
    char* c = "threestring";
    char* c1 = "threestrin";
    char* test1input[] = { a, b, c, 0 };
    char* test1output[] = { b, c1, 0 };
    
    test(test1input,test1output,2,10);
    
    test(test1input,test1input, 10, 20);
    //    test(new String[0], new String[0], 10, 20);
    cout << "done!\n";
    cin.get();  cin.get();
    return 0;
}

static void test(char* input[], char* output[], int nMessagesInStore, int maxMsgLength) {
    MessageStore* self= new MessageStore(nMessagesInStore, maxMsgLength);

    int i;
    for ( i=0; input[i]; i++ ){
        self->AcceptMessage(input[i]); 
    }

    for (i=0; output[i]; i++ ) {
        const char* s = self->GetMessage(i);
        Assert ( strcmp(s, output[i]) == 0,  
                 "message wrong");
    }
    Assert( i == self->NMessagesInStore(), "length wrong" );
}

