 
/* ***************************************************
   File Compression example
   ***************************************************
   */

import  java.io.*;
import java.util.zip.*;

class FileCompression
{
    public static void main( String args[] )
    {
        FileCompression self=new FileCompression();

        byte [][] tests = {
            { 40, 67, 40, 69, 40, 72, 40, 62, 40, 64, 40, 64, 40, 64, 40, 64, 40, 64, 40, 64, 
              40, 66, 40, 66, 40, 59, 40, 61, 40, 62, 40, 61 },
            { 40, 67,  69,  72,  62,  64,  64,  64,  64,  64,  64, 
              66,  66,  59,  61,  62,  61 },
            { 40, 67, 40, 69, 40, 72, 40, 62, 40, 64, 40, 64, 40, 64, 40, 64, 40, 64, 40, 64, 
              40, 66, 40, 66, 40, 59, 40, 61, 40, 62, 40, 61,
              40, 67, 40, 69, 40, 72, 40, 62, 40, 64, 40, 64, 40, 64, 40, 64, 40, 64, 40, 64, 
              40, 66, 40, 66, 40, 59, 40, 61, 40, 62, 40, 61,
              40, 67, 40, 69, 40, 72, 40, 62, 40, 64, 40, 64, 40, 64, 40, 64, 40, 64, 40, 64, 
              40, 66, 40, 66, 40, 59, 40, 61, 40, 62, 40, 61},
            { 42 } , 
            { 0, 0, 0, 40, 67, 40, 69 },
            { 0, 0, 0 },
            {}
        };
        
        for (int i = 0; i < tests.length; i++ ) {
            System.out.println("Test " + i);
            self.test(tests[i]);            
        };
    }

    protected void test(byte[] input) {
        try {
            byte[] intermediate = encodeSequence(input);
            System.out.println("intermediate.length = " + intermediate.length);
            for ( int i=0; i< Math.min( intermediate.length, 20 ); i++ )
                System.out.print( " " + Integer.toString( intermediate[i] & 0xff, 16 ) );
            System.out.println( "" );
            byte[] output = decodeSequence(intermediate);
            
            for ( int i=0; i< input.length; i++ )
                if (input[i] != output[i])
                    {
                        System.err.println( "Error: Output and input differ at " + i + 
                                            ": " + input[i] + "!=" + output[i] );
                    }
            
            System.out.println( intermediate.length + "/" + (input.length) + " " + 
                                (float) intermediate.length * 100.0 / input.length + "%");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
    

    protected static byte[] encodeSequence(byte[] inputSequence) throws IOException {
        InputStream is = new ByteArrayInputStream(inputSequence);
        ByteArrayOutputStream outputArrayStream = new ByteArrayOutputStream();
        GZIPOutputStream out = new GZIPOutputStream(outputArrayStream);
        
        byte[] buf = new byte[1024];
        int len;
        while ((len = is.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        out.close();
        return outputArrayStream.toByteArray();
    }

    protected static byte [] decodeSequence(byte [] s) throws IOException {
        GZIPInputStream is = new GZIPInputStream(new ByteArrayInputStream(s));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        
        byte[] buf = new byte[1024];
        int len;
        while ((len = is.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        out.close();
        return out.toByteArray();
    }
};
