 
/* ***************************************************
   Data Chaining Example.  
   Reversing a text file
   ***************************************************
   */

import  java.io.*;

class ReverseFile
    // Reverses each line in a file
{
    private final int SubfileSize = 10;
    public static void main(String args[])
    {
        try {
            ReverseFile self=new ReverseFile();
            self.run();
        }
        catch (IOException ex) {
            System.err.print(ex);
            System.exit(-1);
        }

        System.out.println("ReverseFile completed");
    }

    public void run() throws IOException {
        scatter(new BufferedReader(new InputStreamReader(System.in)));
        gather(new BufferedWriter(new OutputStreamWriter(System.out)));
    }

    protected void scatter(BufferedReader reader) throws IOException {
        int bytesRead;
        while ((bytesRead = reader.read(buffer, 0, SubfileSize)) > 0) {

            StringBuffer stringBuffer = new StringBuffer(bytesRead);
            stringBuffer.append(buffer, 0, bytesRead);
            stringBuffer.reverse();

            BufferedWriter writer = 
                new BufferedWriter(new FileWriter(subfileName(nSubfiles)));
            writer.write(stringBuffer.toString());
            writer.close();
            nSubfiles++;
        }
    }
    
    protected void gather(BufferedWriter writer) throws IOException {

        for (nSubfiles--; nSubfiles >= 0; nSubfiles--)
            {
                File subFile = new File(subfileName(nSubfiles));
                BufferedReader reader = new BufferedReader(new FileReader(subFile));
                int bytesRead = reader.read(buffer, 0, SubfileSize);
                writer.write(buffer, 0, bytesRead);
                reader.close();
                subFile.delete();
            }
        writer.close();
    }

    protected String subfileName(int n) {
        return "subxx" + n;
    }

    protected int nSubfiles = 0;
    protected char buffer[] = new char[SubfileSize];
};


