 
/* ***************************************************
   Data Chaining Example.  
   Reversing a text file line by line
   ***************************************************
   */

import  java.io.*;

class Reverse
    // Reverses each line in a file
{
    public static void main( String args[] )
    {
        Reverse self=new Reverse();
        
        try  {
            self.doReverse(new BufferedReader(new InputStreamReader(System.in)),
                           new BufferedWriter(new OutputStreamWriter(System.out)));
        }
        catch (IOException ex) {
            System.err.print(ex);
            System.exit(-1);
        }
        
        
        System.out.println( "Reverse completed" );
    }
    
    public void doReverse(BufferedReader reader, BufferedWriter writer) throws IOException {
        String line;
        StringBuffer lineBuffer;
        
        while ((line = reader.readLine())!=null) {
            lineBuffer = new StringBuffer(line);
            lineBuffer.reverse();
            writer.write(lineBuffer.toString());
            writer.newLine();
        }
        writer.close();
    }
};
