
// Wordprocessor: StrapItOn Word-O-Matic!


// Each style has a name.  All styles in a hash table. 

import java.util.*;

class WordOMatic
{
    public static void assert (boolean  assertion, String excuse) {
        if  (!assertion) { throw new RuntimeException(excuse);}
    }
    public static void progress (String msg) {System.out.print(msg);}

    static void main( String[] args )
    {
        progress(".");

        Document doc = new Document();

        progress(".");

        ParagraphFormatCatalog catalog  = doc.catalog();
        catalog.addNewNamedFormat("plain", new ParagraphFormat("Times",10,12,"plain"));
        catalog.addNewNamedFormat("heading 1", new ParagraphFormat("Times",12,14,"plain"));
        catalog.addNewNamedFormat("heading 2", new ParagraphFormat("Arial",10,12,"plain"));
        catalog.addNewNamedFormat("small", new ParagraphFormat("Times",5,6,"small"));

        assert( catalog.findFormat("plain") == catalog.findFormat("plain"), 
                "not sharing plain" );
        assert( catalog.findFormat("heading 1") == catalog.findFormat("heading 1"), 
                "not sharing heading" );
        assert( catalog.findFormat("heading 1") != catalog.findFormat("plain"), 
                "sharing plain ahd heading" );
        
        progress("+");

        doc.insertParagraph(new Paragraph("heading 1"));
        
        assert( doc.currentParagraph().format() == catalog.findFormat("heading 1"),
                "paragraph 0 not heading 1" );
        assert(doc.currentParagraphIndex() == 0, "current paragraph index 0");
        
        for (int i = 0; i < 2; i ++) {

            progress("*");
            ParagraphFormat format = doc.currentParagraph().format().nextParagraphFormat();
            assert( format == catalog.findFormat("plain"),  "loop plain format not plain");
            doc.newParagraph();
            assert(doc.currentParagraphIndex() == i+1, "current paragraph index loop plain");
            assert( doc.currentParagraph().format() == format, "loop plain format not next" );
            assert( doc.currentParagraph().format() == catalog.findFormat("plain"), 
                    "loop plain format not plain");
        }
        
        progress("+");
        doc.insertParagraph(new Paragraph("small"));
        assert(doc.currentParagraphIndex() == 3, "paragraphindex3");
        assert(doc.currentParagraph().format() == catalog.findFormat("small"), 
               "not small 4");
        
        for (int i = 0; i < 2; i ++) {
            progress("_");
            ParagraphFormat format = doc.currentParagraph().format().nextParagraphFormat();
            doc.newParagraph();
            assert( doc.currentParagraph().format() == format, "loop small format not next" );
            assert( doc.currentParagraph().format() == catalog.findFormat("small"), 
                    "loop small format not small");
            assert(doc.currentParagraphIndex() == i+4, "current paragraph index loop small");
        }


        progress("c"); // copy a paragraph 
        
        Paragraph old = doc.getParagraph(3);
        Paragraph copy = (Paragraph) old.clone();
        
        assert( old.format() == copy.format() , "clone not sharing paragraphs");
        assert( old.text != copy.text , "clone sharing text");

        progress("w"); // copy on write when changing paragraph font

        ParagraphFormat fmt = copy.format;
        String origFont = fmt.font();
        copy.setFont("BigAndUgly");
        
        assert( old.format.font() == origFont, "old's font modified");
        assert( copy.format.font() == "BigAndUgly", "mod.format not modified");
        assert( copy.format.font() != old.format.font() , "copy.format not modified");
        assert( old.format == fmt, "old.format changed!");
        assert( copy.format != fmt, "copy.format changed!");

        progress("n"); // copy forced by exposing format

        ParagraphFormat intermediateFormat = copy.format();
        copy.setFont("HugeAndExecrable");
        
        assert( old.format.font() == origFont, "old's font modified");
        assert( old.format == fmt, "old.format changed!");
        assert( copy.format != fmt, "copy.format notchanged!");

        assert( intermediateFormat.font() == "BigAndUgly", "inter's font modified");
        assert( copy.format.font() == "HugeAndExecrable", "mod.format not modified");
        assert( copy.format.font() != old.format.font() , "copy.format not modified");
        assert( copy.format != fmt, "copy.format notchanged!");
        assert( copy.format != intermediateFormat, "copy.format exported!");

        progress("l"); // lazy copy allows in place modification of contained format

        intermediateFormat = copy.format;
        copy.setFont("MicrosoftStandardFont");
        
        assert( old.format.font() == origFont, "old's font modified");
        assert( old.format == fmt, "old.format changed!");
        assert( copy.format != fmt, "copy.format notchanged!");

        assert( intermediateFormat.font() == "MicrosoftStandardFont", 
                "not lazy - inter's font modified");
        assert( copy.format.font() == "MicrosoftStandardFont", "mod.format not modified");
        assert( copy.format.font() != old.format.font() , "copy.format not modified");
        assert( copy.format != fmt, "copy.format notchanged!");
        assert( copy.format == intermediateFormat, "copy.format notlazy!");

        System.out.println("done!");
    }
}

class Document {
    Vector paragraphs = new Vector();  // of Paragraph
    int currentParagraph = -1;

    ParagraphFormatCatalog catalog() {return ParagraphFormatCatalog.catalog();}
    
    Paragraph newParagraph() {
        ParagraphFormat nextParagraphFormat = currentParagraph().format().nextParagraphFormat();
        Paragraph newParagraph = new Paragraph(nextParagraphFormat);
        insertParagraph(newParagraph);
        return newParagraph;
    }

    Paragraph insertParagraph(Paragraph newParagraph) {
        paragraphs.insertElementAt( newParagraph, ++currentParagraph);
        return newParagraph;
    }

    Paragraph getParagraph(int p) {return (Paragraph)paragraphs.elementAt(p);}

    int currentParagraphIndex() {return currentParagraph;}
    Paragraph currentParagraph() {return (Paragraph)paragraphs.elementAt(currentParagraph);}
    void setCurrentParagraphIndex(int p) {currentParagraph = p;}
}

class ParagraphFormat implements Cloneable {
    String defaultFont;
    int fontSize;
    int spacing;

    String font() {return defaultFont;}
    void privateSetFont( String aFont ) { defaultFont = aFont;} 
    String nextParagraphFormat;

    ParagraphFormat(String defaultFontName, int fontSize, int spacing, 
                    String nextParagraphFormat) {
        defaultFont = defaultFontName;
        this.fontSize = fontSize;
        this.spacing = spacing;
        this.nextParagraphFormat = nextParagraphFormat;
    }

    ParagraphFormat nextParagraphFormat() {
        return ParagraphFormatCatalog.catalog().findFormat(nextParagraphFormat);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }


}


class Paragraph implements Cloneable {
    ParagraphFormat format;
    boolean paragraphFormatIsUnique = false;

    StringBuffer text = new StringBuffer();     
    //      ...
    Paragraph(ParagraphFormat format) {
        this.format = format;
    }
    Paragraph(String formatName) {
        this(ParagraphFormatCatalog.catalog().findFormat(formatName));
    }

    protected void aboutToShareParagraphFormat() {
        paragraphFormatIsUnique = false;        
    }

    protected void aboutToChangeParagraphFormat() {
        if (!paragraphFormatIsUnique) {
            try { 
                format = (ParagraphFormat)(format().clone()); 
            } catch (CloneNotSupportedException e) {}
            paragraphFormatIsUnique = true;
        }
    }

    ParagraphFormat format() {
        aboutToShareParagraphFormat();
        return format;
    }

    void setFormat(ParagraphFormat aParagraphFormat) {
        aboutToShareParagraphFormat();
        format = aParagraphFormat;
    }

    public Object clone() {
        try {
            aboutToShareParagraphFormat();
            Paragraph myClone = (Paragraph) super.clone();
            myClone.text =  new StringBuffer(text.toString());
            // note we haven't cloned the format!
            return myClone;
        } catch (CloneNotSupportedException ex) {return null;}
    }

    void setFont(String fontName) {
        aboutToChangeParagraphFormat();
        format.privateSetFont( fontName );
    }
}


//  1. user sets paragraph's format by name;
//  format is shared via hash table 

class ParagraphFormatCatalog {
    private static ParagraphFormatCatalog systemWideCatalog = new ParagraphFormatCatalog();
    public  static ParagraphFormatCatalog catalog() {return systemWideCatalog;}

    Hashtable theCatalog = new Hashtable();
    public void addNewNamedFormat(String name, ParagraphFormat format) {
        theCatalog.put(name,format);
    }
    public ParagraphFormat findFormat(String name) {
        return (ParagraphFormat) theCatalog.get(name);
    }
}
         
