
#include <iostream.h>

class CantLoadLibrary {};
class DLL { public: void* CallTheEntryPoint(); };
class Foo;  DLL*OSLoadLibrary();

class MyLibrary {  friend class RMyLibrary;
public:    
    static void FunctionOne() /*throw CantLoadLibrary*/
        { Instance().FunctionOne(); }
    static Foo* FunctionTwo() /*throw CantLoadLibrary*/
        { return Instance().FunctionTwo(); }
private:
    static const MyLibrary& Instance();
    virtual void DoFunctionOne() const /*throw CantLoadLibrary*/ = 0;
    virtual Foo* DoFunctionTwo() const /*throw CantLoadLibrary*/ = 0;
    
    // The instance is const so it can be in ROM:
    static const MyLibrary* theInstance;
};

class TheLibraryImplementation : public MyLibrary
{
    // There's only one instance of this, 
    //   declared in the library code.
    // No Ctor or Dtor, so the instance can be in ROM
    virtual void DoFunctionOne() const /*throw CantLoadLibrary*/
        { /* The function implementation */ }
    virtual Foo* DoFunctionTwo() const /*throw CantLoadLibrary*/
        { return 0;/* The function implementation */ }
};

const MyLibrary& MyLibrary::Instance()
{
    if (theInstance == 0)
    {
        DLL* aLib = OSLoadLibrary( /* params */ );
        if ( 1 /* error */ )
            throw CantLoadLibrary( /* error information */ );
        // Call the appropriate entry point, which returns
        // a pointer to an instance (perhaps ROM-based) 
        // of TheLibraryImplementation:
        theInstance = static_cast<const MyLibrary*> 
             ( aLib->CallTheEntryPoint() );
    }
    return *theInstance;
}

class RMyLibrary { 
public:
    void FunctionOne()
        { iInstance->DoFunctionOne(); }
    Foo* FunctionTwo()
        { return iInstance->DoFunctionTwo(); }
    void Open()
    { 
        iInstance = 0;
        /* library loading and casting code as before */ 
    }
private:
    const MyLibrary* iInstance;
};

// With this approach, the classes MyLibrary and MyLibraryImplementation have the virtual functions such as DoFunctionOneL just as before.  Clients must do rather more:

int main()
{
    RMyLibrary theLibrary;
    theLibrary.Open();
    Foo* aFoo = theLibrary.FunctionTwo();
    return 0;
}

