/* ***************************************************
   Compaction Example
   Compacting Message Store 
   ***************************************************
   */

import  java.util.*;

class HeapMessageStore
{
    public static void main( String args[] )
    {
        String a = "one string";
        String b  = "twostring";
        String c = "threestring";
        Object [] test1input = { a, b, c };
        
        test(test1input,test1input,20,100);

        Object [] test3input = { "one string", "two string", new Integer(1), "three string" };
        Object [] test3output = { "one string", "three string" };
        test(test3input, test3output, 20, 100);

        Object [] test4input = { "one string", "two string", new Integer(0), "three string" };
        Object [] test4output = { "two string", "three string" };
        test(test4input, test4output, 20, 100);

        Object [] test5input = { "one string", "two string", "three string", 
                                 new Integer(0), new Integer(0), new Integer(0)  };
        Object [] test5output = { };
        test(test5input, test5output, 20, 100);

        Object [] test6input = { "one string", "two string", "three string", 
                                 new Integer(1), "four string" };
        Object [] test6output = { "one string", "three string", "four string" };
        test(test6input, test6output, 20, 100);

        System.out.println("done!");
    }

    protected static void test(Object[] input, Object[] output, int storeSize, int totalStorageCharacters) {
        System.out.print(".");
        HeapMessageStore self=new HeapMessageStore();

        for (int i=0; i < input.length; i++){
            if ((input[i]) instanceof String) {
                self.acceptMessage(((String)input[i]).toCharArray(),
                                   ((String)input[i]).length()); 
            } else {
                self.deleteMessage(((Integer) input[i]).intValue());
            }
        };

        assert( output.length == self.length(), "length wrong" );

        char[] destination = new char[totalStorageCharacters];

        
        for ( int i=0; i< output.length; i++ ){
            String s = new String(destination, 0, self.getMessage(i, destination ));
            assert ( s.equals((String)output[i]),  
                     "message " + i + " wrong! " +  s + " != " + output[i]); 
            assert (self.messageLength(i) == s.length(), 
                    "message " + i + " wrong length " +   
                    self.messageLength(i) + "!=" + s.length() );
        };
    }
    
    protected static void assert (boolean  assertion, String excuse) {
        if  (!assertion) { throw new RuntimeException(excuse);}
    }

    protected Vector messages = new Vector();

    public HeapMessageStore() {
        assert( length() == 0, "buffer calcuations wrong" );
    }


    public void acceptMessage(char[] msg, int msgLength) {
        messages.addElement(new String(msg, 0, msgLength));
    }

    // getMessage: Answers a message into the character array passed.
    // Returns the number of characters in the message.  The character
    // array must be larger than the message. 
    public int getMessage(int i, char[] destination) {
        String me = (String) messages.elementAt(i);
        me.getChars(0, me.length(), destination, 0);
        return me.length();
    }

    public void deleteMessage(int i) {
        messages.removeElementAt(i);
    };

    public int length() {return messages.size();}
    public int messageLength(int m ) { 
        return ((String)messages.elementAt(m)).length();
    } 
};
