
// Wordprocessor: StrapItOn Word-O-Matic!


// Each style has a name.  All styles in a hash table. 

import java.util.*;

class WordOMatic
{
    public static void assert (boolean  assertion, String excuse) {
        if  (!assertion) { throw new RuntimeException(excuse);}
    }
    public static void progress (String msg) {System.out.print(msg);}

    public static void main( String[] args )
    {
        progress(".");

        Document doc = new Document();

        progress(".");

        ParagraphFormatCatalog catalog  = doc.catalog();
        catalog.addNewNamedFormat("plain", 
                                  new ParagraphFormatImplementation("Times",10,12,"plain"));
        catalog.addNewNamedFormat("heading 1", 
                                  new ParagraphFormatImplementation("Times",12,14,"plain")); 
        catalog.addNewNamedFormat("heading 2", 
                                  new ParagraphFormatImplementation("Arial",10,12,"plain")); 
        catalog.addNewNamedFormat("small", 
                                  new ParagraphFormatImplementation("Times",5,6,"small")); 

        ParagraphFormat p = catalog.findFormat("plain");
        assert( p.defaultFont() == "Times" && p.fontSize() == 10 &&
                p.spacing() == 12, "Accessors don't work" );

        assert( catalog.findFormat("plain") == catalog.findFormat("plain"), 
                "not sharing plain" );  
        assert( catalog.findFormat("heading 1") ==
                catalog.findFormat("heading 1"),  
                "not sharing heading" );
        assert( catalog.findFormat("heading 1") !=
                catalog.findFormat("plain"),  
                "sharing plain ahd heading" );
        
        progress("+");

        doc.insertParagraph(new Paragraph("heading 1"));
        
        assert( doc.currentParagraph().format() ==
                catalog.findFormat("heading 1"), 
                "paragraph 0 not heading 1" );
        assert(doc.currentParagraphIndex() == 0, "current paragraph index 0"); 
        
        for (int i = 0; i < 2; i ++) {

            progress("*");
            ParagraphFormat format =
                doc.currentParagraph().format().nextParagraphFormat(); 
            assert( format == catalog.findFormat("plain"),  "loop plain format not plain");   
            doc.newParagraph();
            assert(doc.currentParagraphIndex() == i+1, "current paragraph index loop plain"); 
            assert( doc.currentParagraph().format() == format, "loop plain format not next" );
            assert( doc.currentParagraph().format() == catalog.findFormat("plain"), 
                    "loop plain format not plain");
        }
        
        progress("+");
        doc.insertParagraph(new Paragraph("small"));
        assert(doc.currentParagraphIndex() == 3, "paragraphindex3");
        assert(doc.currentParagraph().format() == catalog.findFormat("small"), 
               "not small 4");
        
        for (int i = 0; i < 2; i ++) {
            progress("_");
            ParagraphFormat format = doc.currentParagraph().format().nextParagraphFormat();
            doc.newParagraph();
            assert( doc.currentParagraph().format() == format, "loop small format not next" );
            assert( doc.currentParagraph().format() == catalog.findFormat("small"), 
                    "loop small format not small");
            assert(doc.currentParagraphIndex() == i+4, "current paragraph index loop small");
        }


        progress("c"); // copy a paragraph 
        
        Paragraph old = doc.getParagraph(3);
        Paragraph copy = (Paragraph) old.clone();
        
        assert( old.format() == copy.format() , "clone not sharing paragraphs");
        assert( old.text != copy.text , "clone sharing text");

        System.out.println("done!");
    }
}

class Document {
    Vector paragraphs = new Vector();  // of Paragraph
    int currentParagraph = -1;

    ParagraphFormatCatalog catalog() {
        return ParagraphFormatCatalog.catalog();}
    
    Paragraph newParagraph() {
        ParagraphFormat nextParagraphFormat =
            currentParagraph().format().nextParagraphFormat(); 
        Paragraph newParagraph = new Paragraph(nextParagraphFormat); 
        insertParagraph(newParagraph);
        return newParagraph;
    }

    Paragraph insertParagraph(Paragraph newParagraph) {
        paragraphs.insertElementAt( newParagraph, ++currentParagraph);
        return newParagraph;
    }

    Paragraph getParagraph(int p) {
        return (Paragraph)paragraphs.elementAt(p);} 

    int currentParagraphIndex() {return currentParagraph;}
    Paragraph currentParagraph() {
        return (Paragraph)paragraphs.elementAt(currentParagraph);}
    void setCurrentParagraphIndex(int p) {currentParagraph = p;}
}

interface ParagraphFormat {
    abstract ParagraphFormat nextParagraphFormat();
    abstract String defaultFont();
    abstract int fontSize();
    abstract int spacing();
}

class ParagraphFormatImplementation implements ParagraphFormat {
    String defaultFont;
    int fontSize;
    int spacing;
    
    String nextParagraphFormat;

    public String defaultFont() { return this.defaultFont; }
    public int fontSize() { return this.fontSize; }
    public int spacing() { return this.spacing; }

    ParagraphFormatImplementation(String defaultFontName, 
                                  int fontSize, int spacing, String nextParagraphFormat) { 
        defaultFont = defaultFontName;
        this.fontSize = fontSize;
        this.spacing = spacing;
        this.nextParagraphFormat = nextParagraphFormat;
    }

    public ParagraphFormat nextParagraphFormat() {
        return ParagraphFormatCatalog.catalog().
            findFormat(nextParagraphFormat);
    }
}

class Paragraph implements Cloneable {
    ParagraphFormat format;
    StringBuffer text = new StringBuffer();     
    //      ...
    Paragraph(ParagraphFormat format) {
        this.format = format;
    }
    Paragraph(String formatName) {
        this(ParagraphFormatCatalog.catalog().findFormat(formatName)); 
    }
    ParagraphFormat format() {return format;}

    public Object clone() {
        try {
            Paragraph myClone = (Paragraph) super.clone();
            myClone.text =  new StringBuffer(text.toString());
            // note we haven't cloned the format!
            return myClone;
        } catch (CloneNotSupportedException ex) {return null;}
    }
}


//  1. user sets paragraph's format by name;
//  format is shared via hash table 

class ParagraphFormatCatalog {
    private static ParagraphFormatCatalog systemWideCatalog 
        = new ParagraphFormatCatalog(); 
    public  static ParagraphFormatCatalog catalog() {
        return systemWideCatalog;} 

    Hashtable theCatalog = new Hashtable();
    public void addNewNamedFormat(String name, ParagraphFormat format) {
        theCatalog.put(name,format);
    }
    public ParagraphFormat findFormat(String name) {
        return (ParagraphFormat) theCatalog.get(name);
    }
}

