#define __VC32__
#include <e32base.h>

// ***************************************************************************
// EPOC Animated Object Factory
//
// Incomplete implementation of EPOC packages, based on a standard tested
// package.
// ***************************************************************************

class CAnimatedObject {};

class CAnimatedObjectFactory : public CBase {
public:
    IMPORT_C ~CAnimatedObjectFactory();
    IMPORT_C void ConstructL(RLibrary& aLib);
    IMPORT_C virtual CAnimatedObject * NewAnimatedObjectL()=0;
private:
    RLibrary iLibraryHandle;
};

CAnimatedObjectFactory* CreateAnimatedObjectFactoryFromDLL(const TDesC& aFileName) {
    RLibrary libraryHandle;
    TInt r=libraryHandle.Load(aFileName);
    if (r!=KErrNone)
        User::Leave(r);
    CleanupClosePushL(libraryHandle);

    if(libraryHandle.Type()[1]!=TUid::Uid(KUidAnimationLibraryModuleV01))
        User::Leave(KErrBadLibraryEntryPoint);

    typedef CAnimatedObjectFactory *(*TAnimatedObjectFactoryNewL)();
    TAnimatedObjectFactoryNewL libEntryL=
        reinterpret_cast<TAnimatedObjectFactoryNewL>(libraryHandle.Lookup(1));
    if (libEntryL==NULL)
        User::Leave(KErrBadLibraryEntryPoint);
    CAnimatedObjectFactory *factoryObject=(*libEntryL)();
    CleanupStack::PushL(factoryObject);

    factoryObject->ConstructL(libraryHandle);
    CleanupStack::Pop(2); // libraryHandle, factoryObject
    return factoryObject;
}


EXPORT_C void CAnimatedObjectFactory::ConstructL(RLibrary& aLib) {
    iLibraryHandle = aLib;
}

EXPORT_C CAnimatedObjectFactory::~CAnimatedObjectFactory() {
    iLibraryHandle.Close();
}

static CAnimatedObjectFactory *iAnimatedObjectFactory;
int main(const TDesC& fileName) {
    iAnimatedObjectFactory = CreateAnimatedObjectFactoryFromDLL( fileName ); 
    CAnimatedObject* newAnimatedObject =
        iAnimatedObjectFactory->NewAnimatedObjectL(); 
	return 0;
}

class CPersonFactory : public CAnimatedObjectFactory {
public:
    virtual CAnimatedObject * NewAnimatedObjectL();
};

class CPerson : public CAnimatedObject {
public:
    CPerson();
    // etc.
};

CAnimatedObject * CPersonFactory::NewAnimatedObjectL() {
    return new(ELeave) CPerson;
}


EXPORT_C CAnimatedObjectFactory * LibEntry() {
    return new CPersonFactory;
}

