
#include <iostream.h>
#include <string.h>
#include <stdio.h>
#include <stddef.h>

static void test(char* input[], char* output[], int storeSize, int chunkSize);


static void Assert (bool  assertion, char* excuse) {
    if  (!assertion) { 
        cerr << "Assertion failed: " << excuse << endl;  
    }
}
#define ASSERT( x ) Assert( (x), #x )

struct ROMableRepresentation {
    int shared;
    int data[100];

    ROMableRepresentation* clone() const { 
        ROMableRepresentation* p = new ROMableRepresentation( *this );
        p->shared = false;
        return p;
    }

    int access( int i ) const { return data[i]; };
    void update( int i, int value )  { data[i] = value; };
};

const ROMableRepresentation inRom =
{ true, { 1, 2, 3, 4, 5, 6 } };

int main() {
    ASSERT( inRom.access(0) == 1 );
    ROMableRepresentation* inRam = inRom.clone();
    ASSERT( inRam->access(0) == 1 );
    inRam->update(0, 2);
    ASSERT( inRam->access(0) == 2 );
    return 0;
}
