
#include <iostream.h>

#define PAUSE() (cin.get(),cin.get())

#define ASSERT( x )  \
((x) ? 0 : &(cout << #x ": Failed: " __FILE__ " " << __LINE__ << endl) \
&& PAUSE() ) 
#define SAY( x ) (cout << x)

class Object { public: int count; };

	Object * objectTable[];

template <class T> class Handle {
public:
	Handle( T** p ) : tableEntry( p ) {}
	// Default copy ctor, assignment, dtor.
	T* operator->() const { return ptr(); }
	T& operator*() const { return *ptr(); }
	operator T*() const { return ptr(); }
private:
	T* ptr() const { return *tableEntry; }
	T** tableEntry;
};


int main() {
    objectTable[0] = new Object;
    Handle<Object> p ( &(objectTable[0]) );
    p->count = 3;
    ASSERT( (*p).count == 3 );
    return 0;
}
