 
/* ***************************************************
   Compaction Example
   Compacting Message Store 
   ***************************************************
   */

import  java.io.*;

class CompactingMessageStore {
    public static void main( String args[] )
    {
        String a = "one string";
        String b  = "twostring";
        String c = "threestring";
        Object [] test1input = { a, b, c };
        
        test(test1input,test1input,20,100);

        Object [] test3input = { "one string", "two string", new
                                 Integer(1), "three string" }; 
        Object [] test3output = { "one string", "three string" };
        test(test3input, test3output, 20, 100);

        Object [] test4input = { "one string", "two string", new
                                 Integer(0), "three string" }; 
        Object [] test4output = { "two string", "three string" };
        test(test4input, test4output, 20, 100);

        Object [] test5input = { "one string", "two string", "three string", 
                                 new Integer(0), new Integer(0), new Integer(0)  };   
        Object [] test5output = { };
        test(test5input, test5output, 20, 100);

        Object [] test6input = { "one string", "two string", "three string", 
                                 new Integer(1), "four string" }; 
        Object [] test6output = { "one string", "three string", "four string" };
        test(test6input, test6output, 20, 100);

        System.out.println("done!");
    }

    protected static void test(Object[] input, Object[] output, int
                               storeSize, int totalStorageCharacters) {
        System.out.print(".");
        CompactingMessageStore self=new
            CompactingMessageStore(storeSize, 
                                   totalStorageCharacters);

        for (int i=0; i < input.length; i++){
            if ((input[i]) instanceof String) {
                self.acceptMessage(((String)input[i]).toCharArray(),
                                   ((String)input[i]).length()); 
            } else {
                self.deleteMessage(((Integer) input[i]).intValue());
            }
        };

        assert( output.length == self.length(), "length wrong" );

        char[] destination = new char[totalStorageCharacters];

        int totalLength = 0;
        
        for ( int i=0; i< output.length; i++ ){
            String s = new String(destination, 0, self.getMessage(i, destination ));
            assert ( s.equals((String)output[i]),  
                     "message " + i + " wrong! " +  s + " != " + output[i]); 
            assert (self.messageLength(i) == s.length(), 
                    "message " + i + " wrong length " +   
                    self.messageLength(i) + "!=" + s.length() );
            totalLength += s.length();
        };
        assert(self.spaceLeft() == (totalStorageCharacters - totalLength),
               "wrong spaceLeft() " + 
               self.spaceLeft() + " != " + (totalStorageCharacters - totalLength));
    }
    
    protected static void assert (boolean  assertion, String excuse) {
        if  (!assertion) { throw new RuntimeException(excuse);}
    }

    protected char[] messageBuffer;
    protected int[] messageLengths;
    protected int numberOfMessages = 0;

    public CompactingMessageStore(int capacity, int totalStorageCharacters) {
        messageBuffer = new char[totalStorageCharacters];
        messageLengths =  new int[capacity];
        assert( length() == 0, "buffer calcuations wrong" );
    }

    protected int indexOfMessage(int m) {
        int result = 0;
        for (m--; m>=0; m--) 
            result += messageLengths[m];
        return result;
    }

    public void acceptMessage(char[] msg, int msgLength) {
        int endOffset = indexOfMessage( numberOfMessages );
        try {
            messageLengths[numberOfMessages] = msgLength;
            System.arraycopy(msg, 0,  messageBuffer, endOffset,
                             msgLength); 
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new OutOfMemoryError("Message store overflow");
        }
        numberOfMessages++;
    }

    // getMessage: Answers a message into the character array passed.
    // Returns the number of characters in the message.  The character
    // array must be larger than the message. 
    public int getMessage(int i, char[] destination) {
        System.arraycopy( messageBuffer, indexOfMessage(i),
                          destination, 0, messageLengths[i]); 
        return messageLengths[i];
    }

    public void deleteMessage(int i) {
        int firstCharToMove = indexOfMessage( i+1 );
        int lastCharToMove = indexOfMessage( numberOfMessages );
        // arraycopy is specified (at least in the Sun implementation)
        // to work correctly for copies to self.
        System.arraycopy(messageBuffer, firstCharToMove,
                         messageBuffer, indexOfMessage( i ), 
                         lastCharToMove - firstCharToMove);
        System.arraycopy(messageLengths, i+1, messageLengths, i,
                         numberOfMessages - i - 1); 
        numberOfMessages--;
    };

    public int length() {return numberOfMessages;}
    public int capacity() {return messageLengths.length;}
    public int totalStorageCharacters() {return messageBuffer.length;}
    public int spaceLeft() { return totalStorageCharacters() -
                                 indexOfMessage(numberOfMessages);} 
    public int messageLength(int m ) {return messageLengths[m];}
};


